local profileID = getenv("DataPlayerProfile")
if not profileID then
	-- !!!!
	Trace("[ScreenDataPlayer overlay] not profileID! ??")
end

local profIndex = PROFILEMAN:GetLocalProfileIndexFromID(profileID)
local profile = PROFILEMAN:GetLocalProfileFromIndex(profIndex)
if not profile then
	-- double !!!!
	Trace(string.format("[ScreenDataPlayer overlay] profile %s (%i) not found!",profileID,profIndex))
end

local avSize = 48
return Def.ActorFrame{
	Def.ActorFrame{
		Name="NameSection";
		InitCommand=cmd(y,SCREEN_CENTER_Y-152;);

		Def.Quad{
			InitCommand=cmd(CenterX;zoomto,500,32;diffuse,color("0.025,0.025,0.025,0.5");fadeleft,0.05;faderight,0.25);
		};
		LoadFont("_francophilsans Bold 24px")..{
			Name="ProfileName";
			InitCommand=cmd(x,SCREEN_CENTER_X-240;halign,0;shadowlength,1.5;zoom,20/24);
			BeginCommand=cmd(settext,profile:GetDisplayName();diffuse,ProfileColor(profile));
		};
		LoadFont("_francophilsans Bold 24px")..{
			Name="FlavorText";
			InitCommand=cmd(xy,SCREEN_CENTER_X+240,4;halign,1;shadowlength,1.5;zoom,14/24;skewx,-0.15);
			BeginCommand=cmd(settext,THEME:GetString("ProfileRanks","StepManiac"));
		};
	};
	Def.ActorFrame{
		Name="QuickStats";
		Def.Sprite{
			Name="Avatar";
			InitCommand=cmd(xy,SCREEN_CENTER_X-212,SCREEN_CENTER_Y-98);
			BeginCommand=function(self)
				local file = profile:GetAvatarFilename()
				if file ~= "" then
					local dir = PROFILEMAN:LocalProfileIDToDir(profileID)
					self:Load(dir..file)
					self:setsize(avSize,avSize)
				else
					self:Load(THEME:GetPathG("","_blank"))
				end
			end;
		};
	};
};